package rendezVous;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Vector;

import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextArea;


public class FenetreAgent extends JFrame implements ActionListener, WindowListener{

	

	//-------------------------------- Variables ---------------------------------------------
	 boolean ok=false;                      		// indique aux agents si les contraintes on etes rentrees
JButton lancement=new JButton ("OK"); 				// un bouton pour valider
JButton random= new JButton ("Random");             // Un bouton pour rentrer des contraintes aleatoires
JButton lier= new JButton ("Changer role");			// Un bouton pour lancer la liaison
private int[][] grille=new int[7][2]; 				// la grille des contraintes
Panneau pan;                         				// Le panneau oe l'ont clique pour rentrer les contraintes
JComboBox imp;                                      // liste deroulante des importances des agents
JComboBox liaison; 									//liste deroulante des liaisons
Vector<String> liai=new Vector<String>();           // vecteur des liaisons choisissables dans la liste deroulante
Vector<Integer> importances=new Vector<Integer>();// vecteur des importances choisissables dans la liste deroulante
private int impor;								   // permet de voir l'importance choisit
Agenda1 agenda1;							       // pour receptionner l'agent qui utilise cette fenetre
String[] nomtot; 								   // tout les roles possibles
String  nomalier;								   // nom de l'agent a lier avec
boolean quitter;								//boolean pour autoriser la fenetre e etre fermee par l'utilisateur
//----------------------------------------------------------------------------------------------------




	public FenetreAgent(String nom, Agenda1 agenda1) // constructeur
	{
		
		quitter=false;
		// reception tableau de noms
		this.nomtot=new String[]{"Informaticien","Economiste","Ressources Humaines","Electricien","Cuisinier"}; 
		ok=false;            // au debut les contraintes n'ont pas ete rentrees
		
		impor=1; // initialisation de l'importance a 1 dans la liste deroulante
		
		setTitle(nom);    // met le nom de l'agent en titre de fenetre
		pan=new Panneau();    // creation de la zone cli
		
		this.agenda1=agenda1;     // pour tuer l'agent si l'utilisateur ferme la fenetre
		setSize(600,400); // taille fenetre	
		
		//----------------- Rentrer les importances cliquables de 0 e 10 dans la liste deroulante -------------
		for(int i=0;i<10;i++)
		{
			importances.add(i);			
		}
		imp=new JComboBox(importances);
		//----------------- ---------------------------------------------------------------------------------------
	
		
		//----------------- Rentrer les liaison cliquables des agents dans la liste deroulante -------------
		liai.add("Independant");
		for(int i=0;i<nomtot.length;i++)
		{
			liai.add(nomtot[i]);
		}
		liaison=new JComboBox(liai);
		liaison.setSelectedIndex(0);
		
		nomalier="Independant";
		//----------------- ---------------------------------------------------------------------------------------
			
		JTextArea text=new JTextArea();                 // creation zone de texte
		JLabel placebouton = new JLabel("");                    // creation d'un label pour placer le bouton
		 placebouton.setPreferredSize(new Dimension(300, 150));   // choix de sa taille
		 getContentPane().add( placebouton, BorderLayout.SOUTH);     // parametres pour placer un bouton
	
		 lancement.setEnabled(true);  // bouton pour lancer cliquable au debut
		 lier.setEnabled(true);  // bouton pour lier cliquable au debut
	//------------------ Choix d'aparences -------------------------------
		 lier.setBounds(190, 100, 150, 35);
		 liaison.setBounds(350, 55, 150, 35);
		random.setBounds(0, 0, 150, 35);
		lancement.setBounds(0, 51, 150, 100);
		imp.setBounds(350, 0, 100, 50);
		text.setBounds(220,0,100,90);
		text.append("   Importance : \n \n \n   \n  Lier avec :");
	//---------------------------------------------------------------------
		
		
		imp.setSelectedIndex(1);  // importance place a 1 au debut
		
		placebouton.add(lier); 		// ajout bouton pour lier
		placebouton.add(liaison); // ajout liste liaison
		placebouton.add(lancement); // ajout bouton pour lancer
		placebouton.add(random); // ajout bouton random
		placebouton.add(text);   // ajout zone de texte
		placebouton.add(imp);  // ajout liste deroulante
		add(pan); 				// ajout du panneau cliquable dans la fenetre
	
		setVisible(true);
		
		setDefaultCloseOperation(DO_NOTHING_ON_CLOSE); // pour fermer la fenetre si l'tilisateur la ferme
		addWindowListener(this);
		
		lier.addActionListener(this);
		lancement.addActionListener(this); // met des ecouteur sur les boutons et les listes
		random.addActionListener(this);
		imp.addActionListener(this);
		liaison.addActionListener(this);
	}

	public void changeNom(String nouvnom)
	{
		setTitle(nouvnom);
	}

	
	


	public void actionPerformed(ActionEvent arg0) { // ecouteur des evenements de la fenetre
		
		int rand=0;
		
		if(arg0.getSource() == liaison) // si on choisi un agent e lier dans la liste deroulante
		{
			JComboBox bo=(JComboBox) arg0.getSource();
		
				nomalier=(String) bo.getSelectedItem();		
		}
		else{
		if(arg0.getSource() == random) // si on appui sur le bouton pour mettre contraintes au random
		{
			for(int i=0;i<7;i++)
			{for(int j=0;j<2;j++)
			{ 
				// rentre les contraintes aleatoirement
				if(Math.random()>0.5)pan.grille[i][j]=0; else pan.grille[i][j]=1; 
			}
			}
			pan.repaint(); // repaint le tableau
		}
		else{
			if(arg0.getSource() ==lier){ // si on appui sur le bouton lier				
				lier();				
			}
			else{
		if(arg0.getSource() == lancement) // si on appui sur le bouton pour accepter
			{
			// on ne peut plus rien faire sur la fenetre
			random.setEnabled(false);liaison.setEnabled(false);lier.setEnabled(false);
			lancement.setEnabled(false);imp.setEnabled(false); 
			
			pan.passageafalse();ok=true; // l'agent est debloque
			}
		else // si on change la liste deroulante
		{
			JComboBox bo=(JComboBox) arg0.getSource();
			impor=(Integer) bo.getSelectedItem(); // on modifie l'importance
		}
		
	}}}}
	
	
	public void lier()
	{
		agenda1.boutonLier(nomalier);
	}
	
	public void fermer() // detruit la fenetre si l'utilisateur la ferme
	{
	dispose();
	}

	public int[][] grille() // rempli la grille de la fenetre avec la grille de son panneau
	{
		for(int i=0;i<7;i++)
		{for(int j=0;j<2;j++)
		{ 	
		this.grille[i][j]= pan.grille()[i][j]; 
		}}
		return grille;
	}
	
	public int importance() // accesseur sur l'importance
	{
		return impor;
	}
	
	public void windowClosing(WindowEvent e) { // si l'on ferme la fenetre ,elle est detruite et l'agent tue
		if(lancement.isEnabled() || quitter){
		agenda1.mortClic();
		agenda1.killAgent(agenda1,0);
		fermer();
		}
	}
	
	//------------- Methodes obligatoires lorsqu'on on implement WindowsListener ---------------
	public void windowActivated(WindowEvent arg0) {	}
	public void windowClosed(WindowEvent arg0) {}
	public void windowDeactivated(WindowEvent arg0) {}
	public void windowDeiconified(WindowEvent arg0) {}
	public void windowIconified(WindowEvent arg0) {}
	public void windowOpened(WindowEvent arg0) {}
	//---------------------------------------------------------------------------------


	
	
	
	
}