package rendezVous;
import madkit.kernel.Agent;
import madkit.kernel.Message;
import madkit.message.ObjectMessage;
import madkit.message.XMLMessage;


// Classe des agents qui ont des contraintes et qui trouve la bonne date

 
public class Agenda1 extends Agent{
	
	//---------------------------------- variables -----------------------------------------------------
	
	// la communaute/role/group de base de ces agents
	String myCommunity="Communaute";
	String myGroup="groupe1";
	String myRole="Independant";
	String nom; // identificateur de l'agent (titre de sa fenetre
	
	int importance=1; // importance de l'agent
	
	
	boolean alive = true; // permet de terminer un agent
	
	int contrainte[]=new int[14]; // tableau des contraintes 1 ou plus =absent , 0=disponible
	int contrainteRole[]=new int[14]; //tablea des contraintes du Role en entier
	int contraintefin[]=new int[14]; // tableau des contraintes finales
	/* 
	 Ces tableaux representent les matins de chaque journee pour 1 semaine.
	  Case 0 = matin lundi, case= 1 aprem lundi, case 2 = matin mardi , ect ...
	 */
	// tableau pour savoir quels roles ont finit leur calcul
	boolean[] rolecacule=new boolean[] {false,false,false,false,false}; 
	// Dans l'ordre : "Informaticien","Economiste","Ressources Humaines","Electricien","Cuisinier";
	
	FenetreAgent fen; // fenetre de l'agent
	
	
	//----------------------------------------------------------------------------------------------------
	
	
	
	
	
	
	public void activate(){ // Ce que fait l'agent a sa creation
		
			requestRole(myCommunity,myGroup,myRole); // chaque agent rentre dans le groupe			
			
			//------------------- Reeoit le nom de l'agent attribue  -------------------------------------
			XMLMessage nomagen= new  XMLMessage("");
			nomagen= (XMLMessage) waitNextMessage();
			
			nom=nomagen.toString();

			//--------------------------------------------------------------------------------------------
			
		
			
			fen=new FenetreAgent(nom+" , "+myRole,this); // creation de la fenetre
			 
//----------------------- Attente de l'utilisateur puis initialisation des contraintes de l'agent --------------------
			 
		while(!fen.ok){//attente des contraintes rentree par l'utilisateur
			nextMessage(); // vide sa pile de message
			pause(100); //pour ne pas fatiguer le processeur	
		}
	
		int Cptcontraintes=0;  
		importance=fen.importance(); // recuperation de l'importance choisi
		
		for(int i=0;i<7;i++)
		{for(int j=0;j<2;j++)
		{
			contrainte[Cptcontraintes]=fen.grille()[i][j]*importance;// initialisation des contraintes
			// initialisation des contraintes du Role
			if(!myRole.equals("Independant"))contrainteRole[Cptcontraintes]=fen.grille()[i][j]*importance;			
			else contrainteRole[Cptcontraintes]=0; // si je suis independant mon tableau de role est vide
				
			contraintefin[Cptcontraintes]=fen.grille()[i][j]*importance; // initialisation des contraintes finales
			Cptcontraintes++;
			}			}
		//---------------------------------------------------------------------------------------------------------------------------
		
		//message envoye au repartisseur pour dire que les contraintes ont bien etaient entree
		sendMessage(myCommunity, myGroup,"repartisseur", new XMLMessage("contraintes ok")); 
				
		// ------------------------------- Attente top depart du repartisseur -----------------------
		Message messagedebut =new Message();
		while(messagedebut.toString()!="Commencez"){// au cas ou un agent se ferait tuer
		messagedebut =   waitNextMessage();}//attente du message du repartisseur pour lancer la recherche

		fen.quitter=true;//boolean pour autoriser la fenetre e etre fermee par l'utilisateur
}
	//----------------------------------------------------------------------------------------------
	
	

	
	

	public void live()
	{
int nbagent=-1; // nombre d'agent dans la session

//-------------------------------  Reception du nombre d'agents (envoye par le repartisseur)------------
while(nbagent==-1){   
Message m = waitNextMessage();  // attente du message du repartisseur indiquant le nombre d'agent choissiseur
if(m!=null)
nbagent=Integer.parseInt(m.toString());
}
//---------------------------------------------------------------------------------------------------------------


//----------------------------- Distribution contraintes par role ------------------------------------------------------


if(!myRole.equals("Independant")) // si j'appartiens a un rele particulier
{
	// j'envoi a mes membres du role mes contraintes et mon importance
	broadcastMessage(myCommunity, myGroup, myRole, new ObjectMessage(new MessageContrEtImp(contrainte,importance))); 
	
Message rolecontr; // pour receptionner les contraintes des autres membres du role
int moyImp=importance; // moyenne des importances du groupe
int nbMembreRole=0; // nombre de membre du role
boolean sortieboucle=false; // savoir quand on sort de la boucle

while(!sortieboucle)
{
	rolecontr=waitNextMessage(500); // j'attend un message
	if(rolecontr==null)sortieboucle=true; // sort quand tout les membres du groupes ont envoye un message
	if(rolecontr instanceof ObjectMessage){ 
	modifContrainteRole(rolecontr); // je modifie mon tableau de contraintes de role
	nbMembreRole++; // j'augmente le nombre de membre a chaque message recu
	
	// on ajoute a la moyenne l'importance de l'agent qui a envoye le message
moyImp=moyImp+(( ObjectMessage<MessageContrEtImp>) rolecontr).getContent().importance;} }
moyImp=moyImp/(nbMembreRole+1); // on divise pour avoir la moyenne

int ajout=(nbMembreRole*moyImp)/2;//L'ajout sur chaque contraintes est egal e 
//la moitie de la moyenne des agents du role * nombre d'agents moins un (les agents potentiellement perturbes)

for(int i=0;i<14;i++) // on modifie le tableau du role pour prendre en compte les perturbes dans le calcul
{
	if(contrainteRole[i]>0){
		//On ajoute l'ajout au tableau de contrainte du role pour prendre en compte le fait 
		//que les agents soit perturbes en cas d'une suppression d'un agent du role
		contrainteRole[i]=contrainteRole[i]+(ajout);
	

}
	// Chaque jour oe le groupe a un membre d'absent a son importance augmente de la moitie de 
	//l'importance de chaque agent du role, car si on est perturbe on est 2 fois moins efficace
}


//j'envoi un message pour dire que je suis pret
sendMessage(myCommunity,myGroup,"repartisseur",new XMLMessage("je suis pret")); 

}
else //si je suis independant
	{ // j'envoi un message pour dire que je suis pret
	sendMessage(myCommunity,myGroup,"repartisseur",new XMLMessage("je suis pret"));
	}

//-----------------------------------------------------------------------------------------------------------------------

		





Message calculcontraintes; // messages reeus pour calcul contraintes finales
boolean fincalcul=false; // pour sortir de la boucle

//------------------------Calcul contraintes finales et contraintes Rele---------------------------

while( !fincalcul) // tant que le calcul n'est pas termine
{
	
	calculcontraintes=waitNextMessage(); // on attends un message 
	
	 
	if(calculcontraintes.getSender().getRole()=="repartisseur")  // s'il vient du repartisseur
	{
		if(calculcontraintes.toString().equals("fin calcul"))
		{fincalcul=true; }//si c'est fin calcul alors on sort de la boucle
		else if(calculcontraintes.toString().equals("depart calcul")) // si c'est depart
		{
			
			if(!myRole.equals("Independant"))
			//  on envoi un message au prochain avec son permier tableau
				envoicontraintessuiv(contrainteRole,myRole,new boolean[5]); 
			else {
				
				leaveRole(myCommunity,myGroup,myRole);//J'abandonnemon ancien role
				 // changement du role de l'agent pour ne plus recevoir le tableau
				requestRole(myCommunity,myGroup,"Independant finit");
				myRole="Independant finit";
				if(isRole(myCommunity,myGroup,"Independant")){ // s'il existe encore des independant
				sendMessage(myCommunity,myGroup,"Independant", new ObjectMessage(contraintefin)); }// envoi du tableau
				
				else {sendMessage(myCommunity,myGroup,"repartisseur", new ObjectMessage(contraintefin));
				} // s'il n'y a plus personne envoi au repartisseur
				
	
			}
		}
		
	}
	else // si le message ne vient pas du repartisseur 
	{
		if(myRole!="Independant" && myRole!="Independant finit") // si j'ai un role 
		{
			
			
			for(int i=0;i<contraintefin.length;i++) // j'ajoute les contraintes du groupe aux contraintes finales
contraintefin[i]=contrainteRole[i]+( (ObjectMessage<MessageContrEtTabl>) calculcontraintes).getContent().contraintes[i];
			
			for(int i=0;i<rolecacule.length;i++) //je recupere ceux a qui faut pas l'envoyer
			rolecacule[i]=((ObjectMessage<MessageContrEtTabl>) calculcontraintes).getContent().Nepasenvoi[i];
			
			rolecacule[roleNum(myRole)]=true; // j'ajoute mon role a ceux qu'il ne faut pas envoyer
			
			
			envoicontraintessuiv(contraintefin,myRole,rolecacule); // j'envoi le message au suivant
		
		}
		else{ // si je suis independant
			for(int i=0;i<contraintefin.length;i++) // j'ajoute mes contraintes aux contraintes finales
			{contraintefin[i]=contrainte[i]+( (ObjectMessage<int[]>) calculcontraintes).getContent()[i];
			
			
			}
			leaveRole(myCommunity,myGroup,myRole);//J'abandonnemon ancien role
			 // changement du role de l'agent pour ne plus recevoir le tableau
			requestRole(myCommunity,myGroup,"Independant finit");
			myRole="Independant finit";
			if(isRole(myCommunity,myGroup,"Independant")){ // s'il existe encore des independant
			sendMessage(myCommunity,myGroup,"Independant", new ObjectMessage(contraintefin));}// envoi du tableau
			
			else {sendMessage(myCommunity,myGroup,"repartisseur", new ObjectMessage(contraintefin));;
			} // s'il n'y a plus personne envoi au repartisseur
						
		}
	}
} 
//--------------------------------------------------------------------------------------------------------


			
//------------------------- Reception message au cas ou pas de solution et envoi si concerne-------------------------------
			//receptionne le message qui contient la position oe il ne faut pas etre (ex : lundi matin)
			Message posiMauvais= waitNextMessage(); 
			if(posiMauvais instanceof ObjectMessage)
			{
			if(myRole.equals("Independant finit")){ 
				leaveRole(myCommunity,myGroup,myRole);//J'abandonnemon ancien role
				// changement du role de l'agent pour ne plus recevoir le tableau
				requestRole(myCommunity,myGroup,"Independant"); 
				myRole="Independant";
				
			}
					
			int pos= (Integer) ((ObjectMessage<?>) posiMauvais).getContent(); // reception dans un tableau
				
			if(contrainte[pos]>0) // si cet agent est absent ce jour la (ou son agent lie)
			{// envoi au repartisseur son nom pour l'indiquer a l'utilisateur
			sendMessage(myCommunity, myGroup, "repartisseur", new XMLMessage(nom+" du rele "+myRole));  
			fen.pan.changeCouleur("mauvais");

			}
			else
			{
			if(contrainteRole[pos]>0)
			{//envoi au repartisseur pour indiquer qu'il est perturbe par l'absence d'un membre du Role
				sendMessage(myCommunity, myGroup, "repartisseur", new XMLMessage(nom+" , "+myRole+" est perturbe")); 
				fen.pan.changeCouleur("groupemauvais");
			}
			else{//envoi au repartisseur pour indiquer qu'il n'est pas concerne
				sendMessage(myCommunity, myGroup, "repartisseur", new XMLMessage("pas moi")); 
				fen.pan.changeCouleur("bon");
			}}
			}// s'il y a une solution tout le monde est peint en vert
			else if(posiMauvais.toString().equals("meurs"))fen.pan.changeCouleur("bon"); 
			//-----------------------------------------------------------------------------------------------------------------------------
			
			
			
			
	}
	
	
	private void envoicontraintessuiv(int[] contraintefin2, String myRole2,	boolean[] rolecacule2) { 
		//fonction qui envoi le tableau de contrainte en parametre a un role qui ne la pas deja fait
		// et qui existe
		
		
		
		boolean sortiebou=false; // pour sortir de la boucle
		int parcours=0; // indice pour prendre le premier role disponible
		rolecacule2[roleNum(myRole2)]=true; //on met dans le tableau que le role de l'agent a bien mit ses contraintes
		
		while(parcours<rolecacule2.length && !sortiebou )
		{
			
			if(rolecacule2[parcours]==false && isRole(myCommunity,myGroup,numRole(parcours)))
			{ // si le rele existe et qu'il a pas deja mit ses contraintes
				 sortiebou=true;
			}
			else parcours++;
		}
		
		
		if(parcours<4){  // s'il y avait un rele restant qui na pas rentre ses contraintes
sendMessage(myCommunity,myGroup,numRole(parcours),new ObjectMessage(new MessageContrEtTabl(contraintefin2,rolecacule2)));
		 // j'envoi a ce role le tableau de contraintes et le tableau qui indique qui a deja rempli le tableau
			}
		
	 // si il n'y a plus de roles qui n'ont pas rempli, j'envoi a un independant (s'il en reste)
else if(isRole(myCommunity,myGroup,"Independant")) 
	sendMessage(myCommunity,myGroup,"Independant",new ObjectMessage(contraintefin2));
		// si tout le monde a rempli le tableau avec ses (ou celles de son groupe) contraintes, j'envoi au repartisseur
		else sendMessage(myCommunity,myGroup,"repartisseur",new ObjectMessage(contraintefin2));
	}
	
	
	private String numRole(int parcours) { // pour connaitre le rele d'une position dans le tableau de booleen 
											// qui indique quel role a deja mit ses contraintes	
		switch (parcours) 
		{ 
		case 0: return "Informaticien"; 
		case 1:return "Economiste"; 
		case 2: return "Ressources Humaines";
		case 3: return "Electricien"; 
		case 4: return "Cuisinier"; 
		default: return null;
		}
	}
	private int roleNum(String role) {// pour connaitre la position d'un rele dans le tableau de booleen 
										// qui indique quel role a deja mit ses contraintes	
		if (role.equals("Informaticien")) return 0;
		else if (role.equals("Economiste")) return 1;
		else if (role.equals("Ressources Humaines")) return 2;
		else if (role.equals("Electricien")) return 3;
		else if (role.equals("Cuisinier")) return 4;
		else return -1;
		
	}

	
	
	
	public void end()
	{
		// previens le repartisseur en cas de mort
		sendMessage(myCommunity, myGroup,"repartisseur", new XMLMessage("je meurs")); 
Message attente=waitNextMessage();

		fen.fermer();	this.killAgent(this,0); // fermer fenetre et l'agent
		
	}
	
	
	

	
	
	
	public void mortClic() // fonction qui se lance si on tue un agent en cliquant sur la croix de sa fenetre
	{
		sendMessage(myCommunity, myGroup,"repartisseur", new XMLMessage("je meurs"));	
		leaveRole(myCommunity, myGroup,myRole);
		killAgent(this,0);
	}
	
	
	
	
	
	
	public void boutonLier(String nouveauRole) // lorsque l'on appui sur le bouton lier
	{leaveRole(myCommunity,myGroup,myRole);//J'abandonnemon ancien role
		myRole=nouveauRole; // changement du role de l'agent
		fen.changeNom(nom+" , "+myRole);
		requestRole(myCommunity,myGroup,nouveauRole);
	}
	
	
	public void modifContrainteRole(Message message) // modifie les contraintes du role avec le message recu
	{
		for(int i=0;i<14;i++)
		{
		contrainteRole[i]=contrainteRole[i]+( ((ObjectMessage<MessageContrEtImp>) message).getContent().contraintes[i]);
			
		}

	}
	
	
	
}
