package rendezVous;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

import javax.swing.JPanel;

public class Panneau extends JPanel implements MouseListener
{

	public int[][] grille=new int[7][2] ; // grilles des contraintes rentres par l'utilisateur
	boolean ok;  // sert a savoir si on peut cliquer sur la grille de choix
	
public Panneau() // constructeur
{ 
	ok=true; // on peut au debut cliquer sur la grille de choix 
	setBackground(Color.WHITE);
	addMouseListener(this); // ecouteur sur la souris
	setVisible(true);
}

public int[][] grille() // la fenetre utilise cette methode pour recevoir la grille du panneau
{
	return grille;
}

public void passageafalse() // pour rendre la grille non cliquable
{
	ok=false;
}

 
	

public void changeCouleur(String coul)
{
	if(coul.equals("bon")) setBackground(Color.green);
	else if(coul.equals("mauvais")) setBackground(Color.red);
	else if (coul.equals("groupemauvais")) setBackground(Color.orange);		
}
			
public void paintComponent(Graphics g) // ce que peindra le panneau a chaque clique
{
		super.paintComponent(g);
		// indique quel jour on clique
g.drawString("   lundi        mardi      mercredi     jeudi    vendredi   samedi   dimanche",10, 10);  
		
		for(int i=0;i<7;i++) // rempli en noir ou blanc en fonction de la valeur de la grille des contraintes
		{for(int j=0;j<2;j++)
		{
		g.setColor(Color.black);
		g.drawRect(i*50+20,j*50+20,50,50);
		switch (grille[i][j])
		{
		case 0:g.setColor(Color.white); break;
		case 1:g.setColor(Color.black); break;

		default:break;
		}
		g.fillRect(i*50+22,j*50+22,48,48); // dessine le rectangle rempli
		}
		}
		
}
	
public void mouseReleased(MouseEvent arg0) { // cequi se passe quand on clique
	 // transforme les coordonnes absolues (pixel) en zone de la grille des contraintes
		int[] casetouche = zone(arg0.getX(),arg0.getY());
		
		if(casetouche[0]!=-1 && casetouche[1]!=-1){ // si l'utilisateur n'as pas clique a cote
			//remplace la contrainte par rapport e la valeur precedente(0 si 1 ou 1 si 0 avant)
			if(ok){grille[casetouche[0]-1][casetouche[1]-1]=1-grille[casetouche[0]-1][casetouche[1]-1];} 
		}
	repaint(); // repaint le panneau
	
	int cpt=0;int[] contrainte=new int[14];
	for(int i=0;i<7;i++)
	{for(int j=0;j<2;j++)
	{
		contrainte[cpt]=grille()[i][j];// initialisation des contraintes	
		cpt++;
	}		
	}
}

public int[] zone(int x,int y) // transforme des variables de position en pixel en coordone d'un tableau de 7 sur 2
{
		int tab[]=new int[2];
		// si l'utilisateur clique a cote le tableau sera e -1
		x=x-20;y=y-20;if(x<0 || x>350 || y<0 || y>100){tab[0]=-1;tab[1]=-1;return tab;} 
		if (x>=0 && x<50)		 	 tab[0]=1;
		if (x>=50 && x<100)		 	 tab[0]=2;
		if (x>=100 && x<150)		 tab[0]=3;
		if (x>=150 && x<200)		 tab[0]=4;
		if (x>=200 && x<250)		 tab[0]=5;
		if (x>=250 && x<300)		 tab[0]=6;
		if (x>=300 && x<=350)		 tab[0]=7;
		
		if (y>=0 && y<50)			 tab[1]=1;
		if (y>=50 && y<=100)		 tab[1]=2;
			
		return tab;
}
	


//-------------------- Methodes obligatoire quand on implement mouseListener-------------
public void mouseClicked(MouseEvent arg0) {}
public void mouseEntered(MouseEvent arg0) {}
public void mouseExited(MouseEvent arg0) {}
public void mousePressed(MouseEvent arg0) {}
//-----------------------------------------------------------------------------------------








}