/*
 * Decompiled with CFR 0.152.
 */
package madkit.kernel;

import java.util.LinkedHashSet;
import java.util.Set;
import madkit.kernel.AbstractAgent;
import madkit.kernel.Probe;

public class Watcher
extends AbstractAgent {
    private static final long serialVersionUID = -4999802785768614838L;
    private final Set<Probe<? extends AbstractAgent>> probes = new LinkedHashSet<Probe<? extends AbstractAgent>>();

    public void addProbe(Probe<? extends AbstractAgent> probe) {
        if (this.kernel.addOverlooker(this, probe)) {
            this.probes.add(probe);
        }
        if (this.logger != null) {
            this.logger.fine("Probe added: " + probe);
        }
    }

    public void removeProbe(Probe<? extends AbstractAgent> probe) {
        this.kernel.removeOverlooker(this, probe);
        this.probes.remove(probe);
    }

    @Override
    protected void activate() {
        if (this.logger != null) {
            this.logger.talk("\n\tHi human !\n\n I am an instance of the madkit.kernel.Watcher class.\n I am specialized in simulation probing.\n I use probes on the artificial society to analyze and\n visualize what is going on in a simulation.\n You can extend me to create your own\n simulation analyzing and visualizing tools !\n");
        }
    }

    @Override
    final void terminate() {
        this.removeAllProbes();
        super.terminate();
    }

    public void removeAllProbes() {
        for (Probe<? extends AbstractAgent> p : this.probes) {
            this.kernel.removeOverlooker(this, p);
        }
        this.probes.clear();
    }

    public Probe<AbstractAgent>[] allProbes() {
        return this.probes.toArray(new Probe[this.probes.size()]);
    }

    public Set<Probe<? extends AbstractAgent>> getProbes() {
        return this.probes;
    }

    @Override
    public String toString() {
        return this.getName() + " " + this.allProbes();
    }
}

