/*
 * Decompiled with CFR 0.152.
 */
package madkit.kernel;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import madkit.i18n.ErrorMessages;
import madkit.i18n.I18nUtilities;
import madkit.kernel.AbstractAgent;
import madkit.kernel.AgentAddress;
import madkit.kernel.Gatekeeper;
import madkit.kernel.Group;
import madkit.kernel.KernelAddress;
import madkit.kernel.MadkitKernel;

final class Organization
extends ConcurrentHashMap<String, Group> {
    private static final long serialVersionUID = 1547623313555380703L;
    private final Logger logger;
    private final String communityName;
    private final transient MadkitKernel myKernel;

    final MadkitKernel getMyKernel() {
        return this.myKernel;
    }

    Organization(String string, MadkitKernel madkitKernel) {
        if (string == null) {
            throw new NullPointerException(ErrorMessages.C_NULL.toString());
        }
        this.communityName = string;
        this.myKernel = madkitKernel;
        this.logger = null;
        if (this.logger != null) {
            this.logger.finer(I18nUtilities.getCGRString(this.communityName) + "created");
        }
    }

    String getName() {
        return this.communityName;
    }

    boolean addGroup(AbstractAgent creator, String group, Gatekeeper gatekeeper, boolean isDistributed) {
        Group g = (Group)this.get(group);
        if (g == null) {
            g = new Group(this.communityName, group, creator, gatekeeper, isDistributed, this);
            this.put(group, g);
            if (this.logger != null) {
                this.logger.fine(I18nUtilities.getCGRString(this.communityName, group) + "created by " + creator.getName() + "\n");
            }
            return true;
        }
        if (this.logger != null) {
            this.logger.finer(I18nUtilities.getCGRString(this.communityName, group) + "already exists: Creation aborted" + "\n");
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeGroup(String group) {
        Organization organization = this;
        synchronized (organization) {
            if (this.logger != null) {
                this.logger.finer("Removing" + I18nUtilities.getCGRString(this.communityName, group));
            }
            this.remove(group);
            this.checkEmptyness();
        }
    }

    private void checkEmptyness() {
        if (this.isEmpty()) {
            if (this.logger != null) {
                this.logger.finer("Removing" + I18nUtilities.getCGRString(this.communityName));
            }
            this.myKernel.removeCommunity(this.communityName);
        }
    }

    ArrayList<String> removeAgentFromAllGroups(AbstractAgent theAgent) {
        ArrayList<String> groups = new ArrayList<String>();
        Iterator e = this.entrySet().iterator();
        while (e.hasNext()) {
            Map.Entry entry = e.next();
            Group g = (Group)entry.getValue();
            if (g.leaveGroup(theAgent) == null) continue;
            if (g.isDistributed()) {
                groups.add((String)entry.getKey());
            }
            if (!g.isEmpty()) continue;
            e.remove();
        }
        return groups;
    }

    Map<String, Map<String, Set<AgentAddress>>> getOrgMap(boolean global) {
        TreeMap<String, Map<String, Set<AgentAddress>>> export = new TreeMap<String, Map<String, Set<AgentAddress>>>();
        for (Map.Entry org : this.entrySet()) {
            if (!global && !((Group)org.getValue()).isDistributed()) continue;
            export.put((String)org.getKey(), (Map<String, Set<AgentAddress>>)((Group)org.getValue()).getGroupMap());
        }
        return export;
    }

    void importDistantOrg(Map<String, Map<String, Set<AgentAddress>>> map) {
        for (String groupName : map.keySet()) {
            Group group = (Group)this.get(groupName);
            if (group == null) {
                AgentAddress manager = null;
                try {
                    manager = map.get(groupName).get("manager").iterator().next();
                }
                catch (NullPointerException e) {
                    manager = map.get(groupName).values().iterator().next().iterator().next();
                }
                group = new Group(this.communityName, groupName, manager, this);
                this.put(groupName, group);
            }
            group.importDistantOrg(map.get(groupName));
        }
    }

    void removeAgentsFromDistantKernel(KernelAddress kernelAddress2) {
        for (Group group : this.values()) {
            if (!group.isDistributed()) continue;
            group.removeAgentsFromDistantKernel(kernelAddress2);
        }
    }

    Logger getLogger() {
        return this.logger;
    }

    void destroy() {
        for (Group g : this.values()) {
            g.destroy();
        }
        this.myKernel.removeCommunity(this.communityName);
    }
}

