/*
 * Decompiled with CFR 0.152.
 */
package madkit.simulation.probe;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import madkit.kernel.AbstractAgent;
import madkit.kernel.Probe;
import madkit.simulation.SimulationException;

public class PropertyProbe<A extends AbstractAgent, T>
extends Probe<A> {
    private final Map<Class<? extends A>, Field> fields = new HashMap<Class<? extends A>, Field>();
    private final String fieldName;
    private Field cachedField;
    private Class<? extends A> cachedClass;

    public PropertyProbe(String community, String group, String role, String fieldName) {
        super(community, group, role);
        this.fieldName = fieldName;
    }

    private void updateCache(A agent) {
        Class<?> agentClass = agent.getClass();
        if (agentClass != this.cachedClass) {
            this.cachedClass = agentClass;
            this.cachedField = this.fields.get(this.cachedClass);
            if (this.cachedField == null) {
                try {
                    this.cachedField = PropertyProbe.findFieldOn(this.cachedClass, this.fieldName);
                    this.fields.put(this.cachedClass, this.cachedField);
                }
                catch (NoSuchFieldException e) {
                    throw new SimulationException(this.toString() + " on " + agent, e);
                }
            }
        }
    }

    public T getPropertyValue(A agent) {
        this.updateCache(agent);
        try {
            return (T)this.cachedField.get(agent);
        }
        catch (IllegalAccessException e) {
            throw new SimulationException(this.toString() + " on " + agent, e);
        }
    }

    public void setPropertyValue(A agent, T value) {
        this.updateCache(agent);
        try {
            this.cachedField.set(agent, value);
        }
        catch (IllegalArgumentException e) {
            throw new SimulationException(this.toString() + " on " + agent, e);
        }
        catch (IllegalAccessException e) {
            throw new SimulationException(this.toString() + " on " + agent, e);
        }
    }

    public T getMaxValue() {
        Object max = null;
        for (AbstractAgent a : this.getCurrentAgentsList()) {
            try {
                T val;
                if (max == null) {
                    max = this.getPropertyValue(a);
                }
                if (((Comparable)(val = this.getPropertyValue(a))).compareTo(max) <= 0) continue;
                max = val;
            }
            catch (ClassCastException e) {
                throw new SimulationException(this.toString() + " on " + a, e);
            }
        }
        return max;
    }

    public T getMinValue() {
        Object min = null;
        for (AbstractAgent a : this.getCurrentAgentsList()) {
            try {
                T val;
                if (min == null) {
                    min = this.getPropertyValue(a);
                }
                if (((Comparable)(val = this.getPropertyValue(a))).compareTo(min) >= 0) continue;
                min = val;
            }
            catch (ClassCastException e) {
                throw new SimulationException(this.toString() + " on " + a, e);
            }
        }
        return min;
    }
}

