/*
 * Decompiled with CFR 0.152.
 */
package madkit.kernel;

import java.io.IOException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import madkit.action.KernelAction;
import madkit.i18n.ErrorMessages;
import madkit.i18n.I18nUtilities;
import madkit.kernel.AgentLogger;
import madkit.kernel.MadkitClassLoader;
import madkit.kernel.MadkitKernel;
import madkit.kernel.MadkitOption;
import madkit.message.KernelMessage;
import madkit.util.MadkitProperties;

public final class Madkit {
    private static final String MDK_LOGGER_NAME = "[* MADKIT *] ";
    static final MadkitProperties defaultConfig = new MadkitProperties();
    static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy.MM.dd.HH.mm.ss");
    public static final String VERSION;
    public static final String BUILD_ID;
    public static final String WEB;
    private final MadkitProperties madkitConfig = new MadkitProperties();
    private final MadkitKernel myKernel;
    private Logger logger;
    String[] args = null;

    public static void main(String[] options) {
        new Madkit(options);
    }

    public void doAction(KernelAction action, Object ... parameters) {
        if (this.myKernel.isAlive()) {
            this.myKernel.receiveMessage(new KernelMessage(action, parameters));
        } else {
            this.logger.severe("my kernel is terminated...");
        }
    }

    public Madkit(String ... options) {
        ArrayList<String> argsList = new ArrayList<String>();
        if (options != null) {
            for (String string : options) {
                argsList.addAll(Arrays.asList(string.trim().split("\\s+")));
            }
            this.args = argsList.toArray(new String[argsList.size()]);
        }
        this.madkitConfig.putAll((Map<?, ?>)defaultConfig);
        Properties fromArgs = this.buildConfigFromArgs(this.args);
        this.madkitConfig.putAll((Map<?, ?>)fromArgs);
        this.initMadkitLogging();
        this.logger.finest("command line args : " + fromArgs);
        this.loadJarFileArguments();
        if (this.loadConfigFiles()) {
            this.loadJarFileArguments();
        }
        this.logger.fine("** OVERRIDING WITH COMMAND LINE ARGUMENTS **");
        this.madkitConfig.putAll((Map<?, ?>)fromArgs);
        I18nUtilities.setI18nDirectory(this.madkitConfig.getProperty(Option.i18nDirectory.name()));
        this.logger.finest(MadkitClassLoader.getLoader().toString());
        if (this.madkitConfig.get(Option.launchAgents.name()).equals("null") && this.madkitConfig.get(Option.configFile.name()).equals("null")) {
            this.logger.fine(Option.launchAgents.name() + " && " + Option.configFile.name() + " == null : Activating desktop");
            this.madkitConfig.setProperty(BooleanOption.desktop.name(), "true");
        }
        this.myKernel = new MadkitKernel(this);
        this.logger.finer("**  MADKIT KERNEL CREATED **");
        this.printWelcomeString();
        this.logSessionConfig(this.madkitConfig, Level.FINER);
        this.startKernel();
    }

    private void loadJarFileArguments() {
        Object[] options = null;
        this.logger.fine("** LOADING JAR FILE ARGUMENTS **");
        try {
            Enumeration<URL> urls = Madkit.class.getClassLoader().getResources("META-INF/MANIFEST.MF");
            while (urls.hasMoreElements()) {
                Manifest manifest = new Manifest(urls.nextElement().openStream());
                Attributes projectInfo = manifest.getAttributes("MaDKit-Project-Info");
                if (projectInfo == null) continue;
                this.logger.finest("found project info \n\t" + projectInfo.keySet() + "\n\t" + projectInfo.values());
                options = projectInfo.getValue("MaDKit-Args").trim().split("\\s+");
                this.logger.finer("JAR FILE ARGUMENTS = " + Arrays.deepToString(options));
                HashMap<String, String> projectInfos = new HashMap<String, String>();
                projectInfos.put("Project-Code-Name", projectInfo.getValue("Project-Code-Name"));
                projectInfos.put("Project-Version", projectInfo.getValue("Project-Version"));
                this.madkitConfig.putAll((Map<?, ?>)this.buildConfigFromArgs((String[])options));
                this.madkitConfig.putAll((Map<?, ?>)projectInfos);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void initMadkitLogging() {
        Level l = LevelOption.madkitLogLevel.getValue(this.madkitConfig);
        this.logger = Logger.getLogger(MDK_LOGGER_NAME);
        this.logger.setUseParentHandlers(false);
        this.logger.setLevel(l);
        ConsoleHandler cs = new ConsoleHandler();
        cs.setLevel(l);
        cs.setFormatter(AgentLogger.AGENT_FORMATTER);
        this.logger.addHandler(cs);
        this.logger.fine("** LOGGING INITIALIZED **");
    }

    private boolean loadConfigFiles() {
        String filesName = this.madkitConfig.getProperty(Option.configFile.name());
        if (!filesName.equals("null")) {
            for (String fileName : filesName.split(";")) {
                this.logger.fine("** Loading config file " + fileName + " **");
                try {
                    this.madkitConfig.loadPropertiesFromFile(fileName.trim());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            return true;
        }
        return false;
    }

    private void startKernel() {
        this.logger.fine("** LAUNCHING KERNEL AGENT **");
        this.myKernel.launchAgent(this.myKernel, this.myKernel, Integer.MAX_VALUE, false);
    }

    public String toString() {
        return this.myKernel.toString() + " @ " + this.myKernel.getKernelAddress();
    }

    private void printWelcomeString() {
        if (LevelOption.madkitLogLevel.getValue(this.madkitConfig) != Level.OFF) {
            System.out.println("\n\t---------------------------------------\n\t                MaDKit\n\t           version: " + VERSION + "\n\t        build-id: " + defaultConfig.getProperty("build.id") + "\n\t       MaDKit Team (c) 1997-" + Calendar.getInstance().get(1) + "\n\t---------------------------------------\n");
        }
    }

    private void logSessionConfig(Properties session, Level lvl) {
        String message = "MaDKit current configuration is\n\n";
        message = message + "\t--- MaDKit regular options ---\n";
        for (String option : defaultConfig.stringPropertyNames()) {
            message = message + "\t" + String.format("%-30s", option) + session.getProperty(option) + "\n";
        }
        HashSet<Object> tmp = new HashSet<Object>(session.keySet());
        tmp.removeAll(defaultConfig.keySet());
        if (tmp.size() > 0) {
            message = message + "\n\t--- Additional non MaDKit options ---\n";
            for (Object e : tmp) {
                message = message + "\t" + String.format("%-25s", e) + session.get(e) + "\n";
            }
        }
        this.logger.log(lvl, message);
    }

    Properties buildConfigFromArgs(String[] options) {
        Properties currentMap = new Properties();
        if (options != null && options.length > 0) {
            String parameters = "";
            String currentOption = null;
            for (int i = 0; i < options.length; ++i) {
                if (options[i].trim().isEmpty()) continue;
                if (options[i].startsWith("--")) {
                    currentOption = options[i].substring(2);
                    currentMap.put(currentOption, "true");
                    parameters = "";
                    continue;
                }
                if (currentOption == null) {
                    System.err.println("\n\t\t!!!!! MADKIT WARNING !!!!!!!!!!!\n\t\tNeeds an option with -- to start with\n\t\targs was : " + Arrays.deepToString(options));
                    return currentMap;
                }
                parameters = parameters + options[i] + " ";
                if (i + 1 != options.length && !options[i + 1].startsWith("--")) continue;
                String currentValue = currentMap.getProperty(currentOption);
                if (currentOption.equals(Option.configFile.name()) && !currentValue.equals("true")) {
                    currentMap.put(currentOption, currentValue + ';' + parameters.trim());
                    continue;
                }
                currentMap.put(currentOption, parameters.trim());
            }
        }
        return currentMap;
    }

    MadkitProperties getConfigOption() {
        return this.madkitConfig;
    }

    MadkitKernel getKernel() {
        return this.myKernel;
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                AgentLogger.resetLoggers();
            }
        });
        try {
            defaultConfig.loadPropertiesFromPropertiesFile("madkit/kernel/madkit.properties");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        VERSION = defaultConfig.getProperty("madkit.version");
        BUILD_ID = defaultConfig.getProperty("build.id");
        WEB = defaultConfig.getProperty("madkit.web");
    }

    public static enum BooleanOption implements MadkitOption
    {
        desktop,
        autoConnectMadkitWebsite,
        network,
        createLogFiles,
        noAgentConsoleLog,
        console,
        loadLocalDemos;


        public boolean isActivated(Properties session) {
            return Boolean.parseBoolean(session.getProperty(this.name()));
        }

        @Override
        public String toString() {
            return "--" + this.name();
        }
    }

    public static enum LevelOption implements MadkitOption
    {
        agentLogLevel,
        kernelLogLevel,
        guiLogLevel,
        madkitLogLevel,
        warningLogLevel,
        networkLogLevel;


        Level getValue(Properties session) {
            try {
                return Level.parse(session.getProperty(this.name()));
            }
            catch (IllegalArgumentException e) {
                Logger.getLogger(Madkit.MDK_LOGGER_NAME).log(Level.SEVERE, ErrorMessages.OPTION_MISUSED.toString() + " " + this.name() + " : " + session.getProperty(this.name()), e);
                return Level.ALL;
            }
        }

        @Override
        public String toString() {
            return "--" + this.name();
        }
    }

    public static enum Option implements MadkitOption
    {
        launchAgents,
        logDirectory,
        desktopFrameClass,
        i18nDirectory,
        configFile,
        agentFrameClass;


        @Override
        public String toString() {
            return "--" + this.name();
        }
    }
}

