/*
 * Decompiled with CFR 0.152.
 */
package madkit.simulation.viewer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import madkit.action.ActionInfo;
import madkit.action.MDKAbstractAction;
import madkit.gui.SwingUtil;
import madkit.i18n.I18nUtilities;
import madkit.kernel.Watcher;

public abstract class SwingViewer
extends Watcher {
    private static final long serialVersionUID = -403113166858504599L;
    private JComponent displayPane;
    private boolean synchronousPainting = true;
    private boolean renderingOn = true;
    private JFrame frame;
    private int renderingInterval;
    private int counter = 0;
    private Action rendering;
    private Action synchroPainting;
    private JToolBar toolBar;

    public SwingViewer() {
        this.initActions();
        this.setSynchronousPainting(true);
        this.displayPane = new JPanel(){
            private static final long serialVersionUID = 3265429181597273604L;

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                SwingViewer.this.render(g);
            }
        };
        this.displayPane.setBackground(Color.WHITE);
        this.createGUIOnStartUp();
    }

    private void initActions() {
        ResourceBundle messages = I18nUtilities.getResourceBundle(SwingViewer.class.getSimpleName());
        this.rendering = new MDKAbstractAction(new ActionInfo("DISABLE", 515, messages)){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        };
        this.rendering.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SwingViewer.this.renderingOn = (Boolean)SwingViewer.this.rendering.getValue("SwingSelectedKey") == false;
            }
        });
        this.setRendering(this.renderingOn);
        this.synchroPainting = new MDKAbstractAction(new ActionInfo("SYNCHRO_PAINTING", 515, messages)){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        };
        this.synchroPainting.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SwingViewer.this.synchronousPainting = (Boolean)SwingViewer.this.synchroPainting.getValue("SwingSelectedKey") == false;
            }
        });
        this.rendering.putValue("SwingSelectedKey", !this.synchronousPainting);
    }

    public boolean isRendering() {
        return this.renderingOn;
    }

    public void setRendering(boolean activated) {
        this.rendering.putValue("SwingSelectedKey", !activated);
    }

    public JComponent getDisplayPane() {
        return this.displayPane;
    }

    public void setDisplayPane(JComponent displayPane) {
        if (this.displayPane != displayPane) {
            if (this.displayPane != null) {
                this.getFrame().remove(this.displayPane);
            }
            this.getFrame().add(displayPane);
            this.displayPane = displayPane;
        }
    }

    protected void observe() {
        if (this.renderingOn && this.isAlive()) {
            if (this.synchronousPainting) {
                if (this.counter == this.renderingInterval) {
                    try {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                SwingViewer.this.displayPane.repaint();
                            }
                        });
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    catch (InvocationTargetException e) {
                        e.printStackTrace();
                    }
                    this.counter = 0;
                } else {
                    ++this.counter;
                }
            } else {
                this.displayPane.repaint();
            }
        }
    }

    protected abstract void render(Graphics var1);

    public boolean isSynchronousPainting() {
        return this.synchronousPainting;
    }

    public void setSynchronousPainting(boolean synchronousPainting) {
        this.synchroPainting.putValue("SwingSelectedKey", !synchronousPainting);
    }

    @Override
    public void setupFrame(JFrame frame) {
        this.displayPane.setSize(frame.getSize());
        frame.add(this.displayPane);
        frame.add((Component)this.getToolBar(), "First");
        this.setFrame(frame);
    }

    public JFrame getFrame() {
        return this.frame;
    }

    public Action getSynchroPaintingAction() {
        return this.synchroPainting;
    }

    private void setFrame(JFrame frame) {
        this.frame = frame;
    }

    public void setRenderingInterval(int interval) {
        this.renderingInterval = interval > 0 ? interval : 1;
    }

    public JToolBar getToolBar() {
        if (this.toolBar == null) {
            this.toolBar = new JToolBar("viewer toolbar");
            SwingUtil.addBooleanActionTo(this.toolBar, this.rendering);
            SwingUtil.addBooleanActionTo(this.toolBar, this.synchroPainting);
            SwingUtil.scaleAllAbstractButtonIconsOf(this.toolBar, 24);
        }
        return this.toolBar;
    }
}

