/*
 * Decompiled with CFR 0.152.
 */
package madkit.pingpong;

import java.awt.Color;
import javax.swing.JFrame;
import javax.swing.JPanel;
import madkit.gui.OutputPanel;
import madkit.kernel.Agent;
import madkit.kernel.AgentAddress;
import madkit.kernel.Madkit;
import madkit.message.ObjectMessage;

public class PingPong
extends Agent {
    private AgentAddress currentPartner = null;
    private ObjectMessage<Color> ball = null;
    private Color ballColor = null;
    private JPanel myPanel;
    private JFrame myFrame;

    @Override
    public void activate() {
        this.createGroupIfAbsent("ping-pong", "room", true, null);
        this.requestRole("ping-pong", "room", "player", null);
    }

    @Override
    public void live() {
        while (true) {
            this.searching();
            this.playing();
        }
    }

    private void searching() {
        this.currentPartner = null;
        this.changeGUIColor(Color.WHITE);
        this.ball = null;
        while (this.currentPartner == null) {
            this.ball = (ObjectMessage)this.waitNextMessage(1000L);
            if (this.ball != null) {
                this.currentPartner = this.ball.getSender();
                continue;
            }
            this.currentPartner = this.getAgentWithRole("ping-pong", "room", "player");
        }
        if (this.logger != null) {
            this.logger.info("I found someone to play with : " + this.currentPartner + " !!!!!! ");
        }
    }

    private void playing() {
        if (this.ball == null) {
            this.ballColor = this.getRandomColor();
            this.ball = (ObjectMessage)this.sendMessageAndWaitForReply(this.currentPartner, new ObjectMessage<Color>(this.ballColor), 1300);
            if (this.ball == null) {
                if (this.logger != null) {
                    this.logger.info(this.currentPartner + " did not reply to me :( !! ");
                }
                this.currentPartner = null;
                return;
            }
        } else {
            this.ballColor = this.ball.getContent();
        }
        this.changeGUIColor(this.ballColor);
        ObjectMessage<Color> objectMessage = new ObjectMessage<Color>(this.ballColor);
        for (int i = 0; i < 10; ++i) {
            this.ball = (ObjectMessage)this.sendReplyAndWaitForReply(this.ball, objectMessage, 1300);
            if (this.ball == null) {
                if (this.logger == null) break;
                this.logger.info(this.currentPartner + " is gone :( !! ");
                break;
            }
            if (this.logger != null) {
                this.logger.info(" Playing :) with " + this.currentPartner + " ball nb is " + i);
            }
            this.pause((int)(Math.random() * 1000.0));
        }
        this.purgeMailbox();
    }

    @Override
    public void setupFrame(JFrame jFrame) {
        this.myPanel = new OutputPanel(this);
        jFrame.add(this.myPanel);
        this.myFrame = jFrame;
    }

    private void changeGUIColor(Color color) {
        if (this.myPanel != null) {
            this.myPanel.setBackground(color);
        }
    }

    public void setFrameLocation(int n, int n2) {
        if (this.myFrame != null) {
            this.myFrame.setLocation(n, n2);
        }
    }

    private Color getRandomColor() {
        return new Color((int)(Math.random() * 256.0), (int)(Math.random() * 256.0), (int)(Math.random() * 256.0));
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = new String[]{"--network", "--launchAgents", PingPong.class.getName(), ",true"};
        Madkit.main(stringArray2);
    }
}

