/*
 * Decompiled with CFR 0.152.
 */
package madkit.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.LogRecord;
import java.util.logging.StreamHandler;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import madkit.kernel.AbstractAgent;
import madkit.kernel.AgentLogger;

public class OutputPanel
extends JPanel {
    private static final long serialVersionUID = 602152712654986449L;
    private final OutputStream out;
    private final JTextArea outField = new JTextArea(5, 32);

    public OutputStream getOutputStream() {
        return this.out;
    }

    public OutputPanel(AbstractAgent agent) {
        this.setLayout(new BorderLayout());
        this.outField.setEditable(false);
        this.setPreferredSize(new Dimension(250, 100));
        this.out = new OutputStream(){

            private void updateText(final String txt) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        OutputPanel.this.outField.append(txt);
                        OutputPanel.this.outField.setCaretPosition(OutputPanel.this.outField.getDocument().getLength());
                    }
                });
            }

            @Override
            public void write(int b) throws IOException {
                this.updateText(String.valueOf((char)b));
            }
        };
        StreamHandler handler = new StreamHandler(this.out, AgentLogger.AGENT_FILE_FORMATTER){

            @Override
            public synchronized void publish(LogRecord record) {
                super.publish(record);
                this.flush();
            }
        };
        agent.getLogger().addHandler(handler);
        this.add("Center", new JScrollPane(this.outField));
        JButton b = new JButton("clear");
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OutputPanel.this.clearOutput();
            }
        });
        this.add("South", b);
    }

    public void clearOutput() {
        this.outField.setText(null);
    }

    @Override
    public void setBackground(Color bg) {
        if (this.outField != null) {
            this.outField.setBackground(bg);
        }
        super.setBackground(bg);
    }
}

